/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.inventory.InventoryCreature;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFear
extends EntityCreatureBase {
    public Entity fearedEntity;

    public EntityFear(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.experience = 0;
        this.hasStepSound = false;
        this.hasAttackSound = false;
        this.spreadFire = false;
        this.func_70105_a(0.8f, 1.8f);
        this.setupMob();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander(this).setPauseRate(0));
    }

    public EntityFear(World world, Entity feared) {
        this(world);
        this.setFearedEntity(feared);
    }

    @Override
    public void setupMob() {
        this.field_70728_aV = 0;
        this.inventory = new InventoryCreature(this.func_70005_c_(), this);
        if (this.mobInfo.defaultDrops) {
            this.loadItemDrops();
        }
        this.loadCustomDrops();
        this.field_70178_ae = true;
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 10.0);
        baseAttributes.put("movementSpeed", 0.38);
        baseAttributes.put("knockbackResistance", 1.0);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 2.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.fearedEntity == null || !this.fearedEntity.func_70089_S() || !(this.fearedEntity instanceof EntityLivingBase)) {
            this.func_70106_y();
            return;
        }
        EntityLivingBase fearedEntityLiving = (EntityLivingBase)this.fearedEntity;
        if (this.canPickupEntity(fearedEntityLiving)) {
            this.pickupEntity(fearedEntityLiving);
        }
        if (this.hasPickupEntity() && !(this.getPickupEntity() instanceof EntityPlayer)) {
            this.getPickupEntity().field_70177_z = this.field_70177_z;
            this.getPickupEntity().field_70125_A = this.field_70125_A;
        }
        if (this.getPickupEntity() == null) {
            this.func_70107_b(this.fearedEntity.field_70165_t, this.fearedEntity.field_70163_u, this.fearedEntity.field_70161_v);
            this.field_70159_w = this.fearedEntity.field_70159_w;
            this.field_70181_x = this.fearedEntity.field_70181_x;
            this.field_70179_y = this.fearedEntity.field_70179_y;
            this.field_70143_R = 0.0f;
        }
        if (ObjectManager.getPotionEffect("fear") == null || !fearedEntityLiving.func_70644_a((Potion)ObjectManager.getPotionEffect("fear"))) {
            this.func_70106_y();
            return;
        }
    }

    public void setFearedEntity(Entity feared) {
        this.fearedEntity = feared;
        this.func_70105_a(feared.field_70130_N, feared.field_70131_O);
        this.field_70145_X = feared.field_70145_X;
        this.field_70138_W = feared.field_70138_W;
        this.func_70012_b(feared.field_70165_t, feared.field_70163_u, feared.field_70161_v, feared.field_70177_z, feared.field_70125_A);
        if (feared instanceof EntityLivingBase && !(feared instanceof EntityPlayer)) {
            EntityLivingBase fearedEntityLiving = (EntityLivingBase)feared;
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(fearedEntityLiving.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b());
        }
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        return false;
    }

    @Override
    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        return false;
    }

    @Override
    public boolean isFlying() {
        if (this.pickupEntity != null) {
            if (this.pickupEntity instanceof EntityCreatureBase) {
                return ((EntityCreatureBase)this.pickupEntity).isFlying();
            }
            if (this.pickupEntity instanceof EntityFlying) {
                return true;
            }
            if (this.pickupEntity instanceof EntityPlayer) {
                return ((EntityPlayer)this.pickupEntity).field_71075_bZ.field_75100_b;
            }
        }
        return false;
    }

    public boolean func_82150_aj() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_98034_c(EntityPlayer player) {
        return true;
    }

    public boolean func_70067_L() {
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return AssetManager.getSound("effect_fear");
    }

    @Override
    protected SoundEvent func_184601_bQ() {
        return AssetManager.getSound("effect_fear");
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return AssetManager.getSound("effect_fear");
    }

    @Override
    public void playFlySound() {
    }
}

